require("Furry/fur")
require("TABAS_FurryShakeAction")

local TABAS_FurryPatches = {}
TABAS_FurryPatches.OnTakeShower = false
TABAS_FurryPatches.OnTakeBath = false
TABAS_FurryPatches.TakeShowerUpdate = false
TABAS_FurryPatches.TakeBathUpdate = false
TABAS_FurryPatches.DrySelfPerform = false

local function washFurClothing(character)
    local furClothing = FurManager.getPlayerWornFur(character)
    if furClothing ~= nil then
        -- Clean fur (this function from FurWashOverride.)
        print('Washing fur...')
        local coveredParts = BloodClothingType.getCoveredParts(furClothing:getBloodClothingType())
        for j = 0, coveredParts:size() - 1 do
            local clothingPart = coveredParts:get(j)
            furClothing:setBlood(clothingPart, 0)
            furClothing:setDirt(clothingPart, 0)
        end
        furClothing:setDirtyness(0)
        furClothing:setBloodLevel(0)
        character:resetModel()
        FurCompatibilityWrappers.sendClothing(character, furClothing:getBodyLocation(), furClothing)
    end
end

function TABAS_FurryPatches.onGameStart()
    if not TABAS_FurryPatches.OnTakeShower then
        local context = require("TABAS_ContextMenuShower")
        local original_OnTakeShower = context.onTakeShower
        function context.onTakeShower(player, object, soapList, useSoap, washOffMakeup, towel, asIsWearing, useHot)
            local playerObj = getSpecificPlayer(player)
            local furClothing = FurManager.getPlayerWornFur(playerObj)
            if furClothing ~= nil then
                towel = nil
            end
            original_OnTakeShower(player, object, soapList, useSoap, washOffMakeup, towel, asIsWearing, useHot)
        end
        print("TABAS_FurryPatches: OnTakeShower done")
        TABAS_FurryPatches.OnTakeShower = true
    end
    if not TABAS_FurryPatches.OnTakeBath then
        local context = require("TABAS_ContextMenuBathtub")
        local original_OnTakeBath = context.onTakeBath
        function context.onTakeBath(player, tfc_Base, towel, washOffMakeup, asIsWearing, bathTime)
            local playerObj = getSpecificPlayer(player)
            local furClothing = FurManager.getPlayerWornFur(playerObj)
            if furClothing ~= nil then
                towel = nil
            end
            original_OnTakeBath(player, tfc_Base, towel, washOffMakeup, asIsWearing, bathTime)
        end
        print("TABAS_FurryPatches: OnTakeBath done")
        TABAS_FurryPatches.OnTakeBath = true
    end

    -- Fur wet to 0 durring shower and cleansed body
    if not TABAS_FurryPatches.TakeShowerUpdate then
        local original_TakeShowerUpdate = TABAS_TakeShower.update
        function TABAS_TakeShower.update(self)
            if self.character:getVariableBoolean("ShowerWashCleansed") and self.doneWash < 2 then
                washFurClothing(self.character)
            end
            
            original_TakeShowerUpdate(self)
            
            local furClothing = FurManager.getPlayerWornFur(self.character)
            if furClothing ~= nil and self.character:getBodyDamage():getWetness() == 0 then
                furClothing:setWetness(0)
            end
        end
        print("TABAS_FurryPatches: TakeShowerUpdate done")
        TABAS_FurryPatches.TakeShowerUpdate = true
    end

    -- Fur wet to 0 durring bath and cleansed body
    if not TABAS_FurryPatches.TakeBathUpdate then
        local original_TakeBathUpdate = TABAS_TakeBath.update
        function TABAS_TakeBath.update(self)
            if self.character:getVariableBoolean("BathTimeWashCleansed") and self.doneWash < 2 then
                washFurClothing(self.character)
            end
            
            original_TakeBathUpdate(self)
            
            local furClothing = FurManager.getPlayerWornFur(self.character)
            if furClothing ~= nil and self.character:getBodyDamage():getWetness() == 0 then
                furClothing:setWetness(0)
            end
        end
        print("TABAS_FurryPatches: TakeBathUpdate done")
        TABAS_FurryPatches.TakeBathUpdate = true
    end
    
    -- Shake action after bathing.
    if not TABAS_FurryPatches.DrySelfPerform then
        local original_DrySelfPerform = TABAS_DrySelf.perform
        function TABAS_ReEquipItems.perform(self)
            local furClothing = FurManager.getPlayerWornFur(self.character)
            if furClothing ~= nil then
                ISTimedActionQueue.add(TABAS_FurryShakeAction:new(self.character, 200))
            end
            original_DrySelfPerform(self)
        end
        print("TABAS_FurryPatches: DrySelfPerform done")
        TABAS_FurryPatches.DrySelfPerform = true
    end
end

Events.OnGameStart.Add(TABAS_FurryPatches.onGameStart)


-- Shake menu durring bathing wet.
function TABAS_FurryPatches.furShakeMenu(player, context, worldObjects, test)
    if test then return end
    
    local playerObj = getSpecificPlayer(player)
    local modData = playerObj:getModData()
    local bathingWetTimer = modData.bathingWetTimer or 0
    local fur = FurManager.getPlayerWornFur(playerObj)
    if fur ~= nil and not playerObj:getVehicle() and not modData.isBathing and bathingWetTimer > 0 then
        context:addOption("Shake Dry", playerObj, TABAS_FurryShakeAction.doShakeAction, playerObj:getSquare())
    end
end

Events.OnFillWorldObjectContextMenu.Add(TABAS_FurryPatches.furShakeMenu)
